#%% przykład na fill_between, zadanie 1
from matplotlib import pyplot as plt
import numpy as np
X=np.linspace(0,1,100)
Y=5*X+3
Y_noise=Y+np.random.normal(0,1,size=len(Y))

from scipy.optimize import curve_fit

def f(x, a, b):
    # p = [a, b]
    return a*x+b

p0=[5,3]
popt, pcov = curve_fit(f, X, Y_noise, p0=p0, sigma=1)
plt.plot(X,Y,color="black", linestyle='--')
X2=np.linspace(-9,11,1000)
Y_fit = f(X2,*popt)
plt.plot(X2,Y_fit,label='fit')
#plt.plot(x,f(x,*p0),label='guess')
#plt.legend()
plt.plot(X,Y_noise,'o')
ax=plt.gca() # axes
sigma_fit = np.sqrt(pcov[0,0]*X2**2 + pcov[1,1] + 2*X2*pcov[0,1])
ax.fill_between(X2,Y_fit-sigma_fit,Y_fit+sigma_fit,alpha=0.4)
# %% zadanie 2
# sinusy bez modyfikacji
T = np.linspace(0,1,1000)
f = np.logspace(0,2,20)

data = []
for f0 in f:
    data.append(np.sin(2*np.pi*f0*T))
data = np.array(data)
#%%
Tm, fm = np.meshgrid(T,f)
data = np.sin(2*np.pi*fm*Tm)
# %%
plt.pcolormesh(Tm,fm,data)
#%%
# model filtra dolnoprzepustowego
fc=20
def absH(f):
    return 1/np.sqrt(1+(f/fc)**2)

def phiH(f):
    return -np.atan(f/fc)

Tm, fm = np.meshgrid(T,f)
data = absH(fm)*np.sin(2*np.pi*fm*Tm+phiH(fm))
plt.pcolormesh(Tm,fm,data)
#%%
plt.plot(data[-1,:])
#%%
plt.plot(f,phiH(f))
#%%
for i, f0 in enumerate(f):
    Y = data[i,:]
    # dla każdej iteracji pętli, robimy fitowanie A sin(2pi f t + phi) + B
    #plt.plot(Y)
